// DebugDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NicCPApplet.h"
#include "NicCPAppDlg.h"
#include "DebugDlg.h"
#include "Advanced.h"
#include "Networkinfo.h"



#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern HANDLE hFile;
extern ConfigData		confData;


/////////////////////////////////////////////////////////////////////////////
// CDebugDlg dialog


CDebugDlg::CDebugDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDebugDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDebugDlg)
	m_TraceMaskValue = 0;
	m_RawAt = _T("");
	//}}AFX_DATA_INIT

}


void CDebugDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDebugDlg)
	DDX_Control(pDX, IDC_RAWATDATA, m_RawAtDataCtl);
	DDX_Control(pDX, IDC_RAWAT, m_RawAtCtl);
	DDX_Control(pDX, IDC_COPY, m_Copy);
	DDX_Control(pDX, IDC_TRACINGSTATIC, m_TracingStatic);
	DDX_Control(pDX, IDC_GETTRACE, m_Trace);
	DDX_Control(pDX, IDC_CLEAR, m_ClearCtl);
	DDX_Control(pDX, IDC_EDITTRACE, m_EditTrace);
	DDX_Text(pDX, IDC_TRACEMASKVALUE, m_TraceMaskValue);
	DDX_Text(pDX, IDC_RAWATDATA, m_RawAt);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDebugDlg, CDialog)
	//{{AFX_MSG_MAP(CDebugDlg)
	ON_BN_CLICKED(IDC_GETTRACE, OnGettrace)
	ON_BN_CLICKED(IDC_CLEAR, OnClear)
	ON_BN_CLICKED(IDC_COPY, OnCopy)
	ON_BN_CLICKED(IDC_RAWAT, OnRawat)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()






DWORD WINAPI ThreadProc(LPVOID lpParameter)
{

	DWORD bytesback;
	CDebugDlg* pDlg		= (CDebugDlg*)lpParameter;
	
	CHAR	buf[1024];


	while(pDlg->keeprunning == true)
	{

		if(hFile)
		{
			// get trace data
			if(DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_TRACE, 0, 0, buf, 1024, &bytesback,NULL))
			{
				if(bytesback)
				{

					WaitForSingleObject(pDlg->traceEvent, INFINITE);
		
					ResetEvent(pDlg->traceEvent);

					for(DWORD i = 0 ; i < bytesback; i ++)
					{
						pDlg->m_EditTrace.SendMessage(WM_CHAR, buf[i], 0);
						pDlg->m_CharCount++;
					}

					SetEvent(pDlg->traceEvent);
				}
			}

			// on error, stop tracing
			else
			{
				pDlg->keeprunning = false;
				break;
			}

			// if we maxed out on chars, reset the window
			if(pDlg->m_CharCount >= 102400)
			{
				pDlg->m_EditTrace.SetSel(0, -1);
				pDlg->m_EditTrace.Clear();
				pDlg->m_CharCount =0;
			}
		}

		// rest abit
		Sleep(10);
	}
	
	if(hFile)
		DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_STOP_TRACE, 0, 0, 0, 0, &bytesback,NULL);

	return 0;
}



/////////////////////////////////////////////////////////////////////////////
// CDebugDlg message handlers


BOOL CDebugDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CString str;


	m_EditTrace.SetLimitText(102400);
	m_TraceMaskValue = 14;


	str.LoadString(IDS_TRACINGLEVELTEXT);
	m_TracingStatic.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_STOPTRACE);
	m_Trace.SetWindowText((LPCTSTR)str);


	str.LoadString(IDS_CLEAROUTPUT);
	m_ClearCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_COPY);
	m_Copy.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_WIRELESSWANTRACE);
	this->SetWindowText((LPCTSTR)str);


	str.LoadString(IDS_DIRECTAT);
	m_RawAtCtl.SetWindowText((LPCTSTR)str);

	if((hFile != INVALID_HANDLE_VALUE) && (hFile != NULL) )
	{
		m_RawAtCtl.EnableWindow(TRUE);
		m_RawAtDataCtl.EnableWindow(TRUE);
	}



	traceEvent = CreateEvent(NULL, TRUE, FALSE,  "traceEvt");

	SetEvent(traceEvent);

	UpdateData(FALSE);


	this->OnGettrace();

//	keeprunning = true;
//	HANDLE		trH;
//	trH = CreateThread(NULL, 0, 
//						  &ThreadProc,    // thread function
//						  this,                       // thread argument
//						  0,						// creation option
//						  0);                        // thread identifier
//	str.LoadString(IDS_STOPTRACE);
//	m_Trace.SetWindowText((LPCTSTR)str);


	return TRUE;  
}




void CDebugDlg::OnGettrace() 
{
	CString str;
	DWORD bytesback;

	if(keeprunning == false)
	{
		UINT a = 0;

		// get the trace value and write it to the driver
		UpdateData(TRUE);
		
		if(m_TraceMaskValue >= 0)
		{
			if(hFile)
				DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_SET_TRACE_MASK, &m_TraceMaskValue, sizeof(UINT), 0, 0, &bytesback,NULL);
		}


		keeprunning = true;
		HANDLE		trH;

		trH = CreateThread(NULL, 0, 
						  &ThreadProc,    // thread function
						  this,                       // thread argument
						  0,						// creation option
						  0);                        // thread identifier
		
		str.LoadString(IDS_STOPTRACE);
		m_Trace.SetWindowText((LPCTSTR)str);

		return;
	}
	
	keeprunning = false;

	str.LoadString(IDS_STARTTRACE);
	m_Trace.SetWindowText((LPCTSTR)str);

}


void CDebugDlg::OnClear() 
{
	m_EditTrace.SetSel(0, -1);
	m_EditTrace.Clear();
	m_CharCount =0;
}



void CDebugDlg::doerror()
{
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	// Process any inserts in lpMsgBuf.
	// ...
	// Display the string.
//	MessageBox( (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
	// Free the buffer.
	LocalFree( lpMsgBuf );

}

void CDebugDlg::OnCopy() 
{

	this->m_EditTrace.SetSel(0,-1);

	this->m_EditTrace.SendMessage(WM_COPY, 0, 0);

	this->m_EditTrace.SetSel(-1,-1);

}

void CDebugDlg::OnRawat() 
{

	DWORD bytesback;
	UpdateData(TRUE);
	
	CHAR	buf[256];
	CHAR	buf1[4098];
	CHAR	CR=13;
	CHAR	null='\0';
	
	
	
	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;


	strcpy(buf, m_RawAt);

	if((buf[0] != 'a') && (buf[0] != 'A'))
	{
		m_RawAt = "Invalid AT command";
		UpdateData(FALSE);
		return;
	}

	buf[m_RawAt.GetLength()] = CR;
	buf[m_RawAt.GetLength()+1] = '\0';

	this->wait = true;

	this->OnSetCursor();


	if(hFile)
	{
		if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_RAW_AT, buf, m_RawAt.GetLength()+1, buf1, 4098, &bytesback,NULL))
		{
			doerror(); 
		}
	}

	this->wait = false;

	this->OnSetCursor();

	
}

void CDebugDlg::OnSetCursor()
{
	HCURSOR hCurs1;

	if(wait)
		hCurs1 = LoadCursor(NULL, IDC_WAIT); 

	else
		hCurs1 = LoadCursor(NULL, IDC_ARROW); 

	::SetCursor(hCurs1); 	
}



void CDebugDlg::OnClose() 
{
	keeprunning = false;

	CDialog::OnClose();

	::PostMessage(::FindWindow(NULL, "Wireless WAN Configuration"), WM_KILL_DEBUG_POINTER, 0, 0);
}

