// Networkinfo.cpp : implementation file
//

#include "stdafx.h"
#include "NicCPApplet.h"
#include "NicCPAppDlg.h"
#include "DebugDlg.h"
#include "Advanced.h"
#include "Networkinfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


extern HANDLE hFile;
extern ConfigData		confData;


/////////////////////////////////////////////////////////////////////////////
// CNetworkinfo dialog


CNetworkinfo::CNetworkinfo(CWnd* pParent /*=NULL*/)
	: CDialog(CNetworkinfo::IDD, pParent)
{
	//{{AFX_DATA_INIT(CNetworkinfo)
	m_StatusStr = _T("");
	m_TcpWindowSize = 0;
	//}}AFX_DATA_INIT
}


void CNetworkinfo::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CNetworkinfo)
	DDX_Control(pDX, IDC_SETTCPWINDOWSIZE, m_SetTcpWindowSizeCtl);
	DDX_Control(pDX, IDCANCEL, m_CancelCtl);
	DDX_Control(pDX, IDC_STATUS, m_StatusCtl);
	DDX_Control(pDX, IDC_QUERYSTATUS, m_QueryStatusCtl);
	DDX_Control(pDX, IDC_QUERYSTATS, m_QueryStatsCtl);
	DDX_Control(pDX, IDC_QUERYIP, m_QueryIpCtl);
	DDX_Control(pDX, IDC_IPADDRESSQUERYCLIENT, m_IPAddressCtl);
	DDX_Text(pDX, IDC_STATUS, m_StatusStr);
	DDX_Text(pDX, IDC_TCPWINDOWSIZE, m_TcpWindowSize);
	DDV_MinMaxUInt(pDX, m_TcpWindowSize, 0, 256000);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CNetworkinfo, CDialog)
	//{{AFX_MSG_MAP(CNetworkinfo)
	ON_BN_CLICKED(IDC_QUERYSTATS, OnQuerystats)
	ON_BN_CLICKED(IDC_QUERYSTATUS, OnQuerystatus)
	ON_BN_CLICKED(IDC_QUERYIP, OnQueryip)
	ON_BN_CLICKED(IDC_SETTCPWINDOWSIZE, OnSettcpwindowsize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CNetworkinfo message handlers

void CNetworkinfo::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CNetworkinfo::OnQuerystats() 
{
	GT_NDISGPRSStats		stats;
	DWORD bytesback;

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;


	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_QUERY_STATS, NULL, 0, &stats, sizeof(GT_NDISGPRSStats), &bytesback,NULL))
	{
		doerror(); 
	}
	else
	{
		if(bytesback != sizeof(GT_NDISGPRSStats))
		{
// 			MessageBox("Arrgh!. Bytesback not same as stats struct", "Error", MB_OK); 
			return;
		}

		CHAR	a1[80];
		CHAR	a2[80];
		CHAR	a3[80];
		CHAR	a4[80];
		CHAR	a5[80];
		CHAR	a6[80];

		itoa(stats.BytesXmited, a1, 10);
		itoa(stats.BytesRcved, a2, 10);
		itoa(stats.FramesXmited, a3, 10);
		itoa(stats.FramesRcved, a4, 10);
		itoa(stats.Errors, a5, 10);
		itoa(stats.ConnectDuration, a6, 10);

		CString	buf;

		buf = CString("Bytes Xmited: ") + a1 + "\n" +  
			  "Bytes Rcvd: " + a2 + "\n" +
			  "Frames Xmited: " + a3 + "\n" +
			  "Frames Rcvd: " + a4 + "\n" +
			  "Errors: " + a5 + "\n" +
			  "Connection Duration: " + a6;

		MessageBox(buf, "Data", MB_OK);
		
		

	}
	
}

void CNetworkinfo::OnQuerystatus() 
{

	DWORD bytesback;
	GT_NDISGPRSStatus	status;


	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;

	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_QUERY_STATUS, NULL, 0, &status, sizeof(GT_NDISGPRSStatus), &bytesback,NULL))
	{
		doerror(); 
	}
	else
	{
		if(bytesback != sizeof(GT_NDISGPRSStatus))
		{
// 			MessageBox("Arrgh!. Bytesback not same as status struct", "Error", MB_OK); 
			return;
		}

		CHAR szBuf[80]; 
		itoa(status.Reason, szBuf, 10);

		CHAR szBuf1[80]; 
		itoa(status.Status, szBuf1, 10);

		CHAR buf[256];

		strcpy(buf, szBuf);
		strcat(buf, "   ");
		strcat(buf, szBuf1);
 		

		m_StatusStr = buf;
		
		UpdateData(FALSE);
	}
	
}

void CNetworkinfo::OnQueryip() 
{
	GT_NDISGPRSIpAddr		ipaddr;
	DWORD bytesback;

	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;



	if(!DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_GPRS_QUERY_IP_INFO, NULL, 0, &ipaddr, sizeof(GT_NDISGPRSIpAddr), &bytesback,NULL))
	{
		doerror(); 
	}
	else
	{
		if(bytesback != sizeof(GT_NDISGPRSIpAddr))
		{
// 			MessageBox("Arrgh!. Bytesback not same as ip struct", "Error", MB_OK); 
			return;
		}

		m_IPAddressCtl.SetAddress(*((DWORD*)&ipaddr));
	}
	
}
void CNetworkinfo::doerror()
{
	LPVOID lpMsgBuf;
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		GetLastError(),
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
	);
	// Process any inserts in lpMsgBuf.
	// ...
	// Display the string.
//	MessageBox( (LPCTSTR)lpMsgBuf, "Error", MB_OK | MB_ICONINFORMATION );
	// Free the buffer.
	LocalFree( lpMsgBuf );

}

BOOL CNetworkinfo::OnInitDialog() 
{
	CDialog::OnInitDialog();
	CString str;

	
	str.LoadString(IDS_QUERYIP);
	this->m_QueryIpCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_QUERYSTATS);
	this->m_QueryStatsCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_QUERYSTATUS);
	this->m_QueryStatusCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_CLOSE);
	this->m_CancelCtl.SetWindowText((LPCTSTR)str);

	str.LoadString(IDS_NETWORKINFODIALOG);
	this->SetWindowText((LPCTSTR)str);

	UpdateData(FALSE);
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CNetworkinfo::OnSettcpwindowsize() 
{
	UpdateData(TRUE);
	DWORD bytes;
	
	if(!hFile)
		return;

	if(hFile == INVALID_HANDLE_VALUE)
		return;

	DeviceIoControl(hFile, IOCTL_GT_NDIS_GPRS_SET_TCPWINDOWSIZE, &m_TcpWindowSize, sizeof(m_TcpWindowSize), NULL, 0, &bytes, NULL);
}
